/*
 * Decompiled with CFR 0.152.
 */
package jemu.ui;

import com.sun.j3d.utils.geometry.Sphere;
import com.sun.j3d.utils.image.TextureLoader;
import com.sun.j3d.utils.universe.ConfiguredUniverse;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.awt.image.MemoryImageSource;
import java.awt.image.WritableRaster;
import java.net.URL;
import javax.imageio.ImageIO;
import javax.media.j3d.Appearance;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.ImageComponent2D;
import javax.media.j3d.PolygonAttributes;
import javax.media.j3d.TexCoordGeneration;
import javax.media.j3d.Texture2D;
import javax.media.j3d.TextureAttributes;
import javax.media.j3d.Transform3D;
import javax.swing.ButtonGroup;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.SwingUtilities;
import javax.vecmath.Color4f;
import javax.vecmath.Vector4f;
import jemu.settings.Settings;
import jemu.ui.Desktop;
import jemu.ui.Display;
import jemu.ui.JEMU;
import jemu.ui.Switches;

public class CurvaturedScreen
extends JPanel
implements ActionListener,
FocusListener,
MouseListener {
    public JFrame fullFrame;
    JPanel screen3D;
    Panel canvas;
    Cursor blankcursor;
    protected int texsizeX;
    protected int texsizeY;
    int sizex = 384;
    int sizey = 272;
    protected int offx;
    protected int offy;
    TextureLoader loader;
    Texture2D texture;
    Appearance appearance;
    BranchGroup group;
    Sphere sphere;
    private final PolygonAttributes polygonattributes;
    ButtonGroup but = new ButtonGroup();
    JRadioButton but1;
    JRadioButton but2;
    JRadioButton but3;
    ConfiguredUniverse universe;
    JPanel buts = new JPanel();
    boolean ispainted = true;
    BufferedImage mask;
    BufferedImage maskedges;
    BufferedImage mask2;
    BufferedImage glance;
    int primflags;
    Display Display;
    protected final int polygons = 256;
    protected boolean halfsize = true;
    protected boolean DEBUG = false;
    protected WritableRaster raster;
    protected int[] pixels;
    protected ImageComponent2D imagecomponent;
    protected BufferedImage display;
    protected Graphics g;
    protected boolean skip;
    protected int frame;
    protected int startoff;
    protected int imageoffset;
    protected int y;
    protected boolean toggleit;
    protected int[] spixels;
    protected boolean repaint;
    protected int forcedraw = 0;
    protected int firsttime = 0;
    Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
    boolean fullZoom = false;
    BorderLayout borderlay = new BorderLayout();
    FlowLayout flowlay = new FlowLayout();
    boolean hasFocus;
    public static boolean FullScreen;
    JLabel fps;
    BufferedImage pattern = new BufferedImage(768, 544, 2);
    int fpsdelay = 0;
    boolean imask;

    @Override
    public void mouseReleased(MouseEvent e) {
        this.screen3D.transferFocus();
        this.screen3D.requestFocus();
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void focusLost(FocusEvent e) {
        if (this.hasFocus) {
            System.out.println("3d-Panel: Focus lost");
        }
        this.hasFocus = false;
        this.screen3D.setCursor(Cursor.getDefaultCursor());
    }

    @Override
    public void focusGained(FocusEvent e) {
        if (!this.hasFocus) {
            System.out.println("3d-Panel: Focus gained");
        }
        this.hasFocus = true;
        if (Desktop.hideMouse.isSelected()) {
            this.screen3D.setCursor(this.blankcursor);
        } else {
            this.screen3D.setCursor(Cursor.getDefaultCursor());
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.but1) {
            this.setRenderMode(0);
        } else if (e.getSource() == this.but2) {
            this.setRenderMode(1);
        } else if (e.getSource() == this.but3) {
            this.setRenderMode(2);
        }
    }

    public void toggleFullScreen() {
        FullScreen = !FullScreen;
        this.firsttime = 0;
        if (FullScreen) {
            if (Desktop.isDesktop) {
                Desktop.setVis = false;
                Desktop.visTimer = 1;
            } else {
                JEMU.frame.setVisible(false);
            }
            this.remove(this.screen3D);
            this.canvas.add(this.screen3D);
            this.fullFrame.setVisible(true);
        } else {
            if (Desktop.isDesktop) {
                Desktop.setVis = true;
                Desktop.visTimer = 1;
            } else {
                JEMU.frame.setVisible(true);
            }
            this.fullFrame.setVisible(false);
            this.canvas.remove(this.screen3D);
            this.add((Component)this.screen3D, "Center");
        }
    }

    public void resizeCanvas() {
        try {
            if ((double)(this.fullFrame.getHeight() / this.fullFrame.getWidth()) < 1.3333333333333333) {
                if (this.screen3D.getHeight() != this.fullFrame.getHeight()) {
                    System.out.println("Resizing 3d screen to " + this.getAspectWidth(this.fullFrame.getHeight()) + "," + this.fullFrame.getHeight());
                    this.screen3D.setPreferredSize(new Dimension(this.getAspectWidth(this.fullFrame.getHeight()), this.fullFrame.getHeight()));
                    this.screen3D.setSize(new Dimension(this.getAspectWidth(this.fullFrame.getHeight()), this.fullFrame.getHeight()));
                    this.setPreferredSize(new Dimension(this.getAspectWidth(this.fullFrame.getHeight()), this.fullFrame.getHeight()));
                    this.setSize(new Dimension(this.getAspectWidth(this.fullFrame.getHeight()), this.fullFrame.getHeight()));
                    this.fullFrame.repaint();
                }
            } else if (this.screen3D.getWidth() != this.fullFrame.getWidth()) {
                System.out.println("Resizing 3d screen to " + this.fullFrame.getWidth() + "," + this.getAspectHeight(this.fullFrame.getWidth()));
                this.screen3D.setPreferredSize(new Dimension(this.fullFrame.getWidth(), this.getAspectHeight(this.fullFrame.getWidth())));
                this.screen3D.setSize(new Dimension(this.fullFrame.getWidth(), this.getAspectHeight(this.fullFrame.getWidth())));
                this.setPreferredSize(new Dimension(this.fullFrame.getWidth(), this.getAspectHeight(this.fullFrame.getWidth())));
                this.setSize(new Dimension(this.fullFrame.getWidth(), this.getAspectHeight(this.fullFrame.getWidth())));
                this.fullFrame.repaint();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int getAspectHeight(int in) {
        return (int)((double)in / 1.3333333333333333);
    }

    public int getAspectWidth(int in) {
        return (int)((double)in * 1.3333333333333333);
    }

    public void toggleZoom() {
        boolean bl = this.fullZoom = !this.fullZoom;
        if (this.fullZoom) {
            this.canvas.setLayout(this.borderlay);
        } else {
            this.canvas.setLayout(this.flowlay);
        }
        this.toggleFullScreen();
        this.toggleFullScreen();
        this.screen3D.requestFocus();
        this.canvas.repaint();
        this.fullFrame.repaint();
    }

    protected void init() {
        this.firsttime = 0;
        this.but1.addActionListener(this);
        this.but2.addActionListener(this);
        this.but3.addActionListener(this);
        this.setLayout(new BorderLayout());
        this.screen3D.setLayout(new BorderLayout());
        this.screen3D.add((Component)this.universe.getCanvas(), "Center");
        this.resizeCanvas();
        this.screen3D.setBackground(Color.black);
        this.screen3D.setOpaque(false);
        this.setOpaque(false);
        if (this.DEBUG) {
            this.screen3D.add((Component)this.buts, "South");
        }
        this.universe.getCanvas().setFocusable(false);
        this.universe.getCanvas().setDoubleBufferEnable(true);
        this.texture.setImage(0, this.imagecomponent);
        this.screen3D.setVisible(true);
        this.screen3D.setFocusable(true);
        this.add((Component)this.screen3D, "Center");
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CurvaturedScreen.this.screen3D.requestFocus();
            }
        });
    }

    public void setRenderMode(int i) {
        switch (i) {
            case 0: {
                this.polygonattributes.setPolygonMode(2);
                break;
            }
            case 1: {
                this.polygonattributes.setPolygonMode(1);
                break;
            }
            case 2: {
                this.polygonattributes.setPolygonMode(0);
            }
        }
    }

    public CurvaturedScreen(Display disp) {
        this.Display = disp;
        this.fullFrame = new JFrame(){

            @Override
            protected void processWindowEvent(WindowEvent e) {
                super.processWindowEvent(e);
                if (e.getID() == 201) {
                    CurvaturedScreen.this.toggleFullScreen();
                }
            }
        };
        int[] pixelsc = new int[256];
        Image imagec = Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(16, 16, pixelsc, 0, 16));
        this.blankcursor = Toolkit.getDefaultToolkit().createCustomCursor(imagec, new Point(0, 0), "invisibleCursor");
        this.fullFrame.setUndecorated(true);
        this.fullFrame.setPreferredSize(new Dimension(this.dim));
        this.fullFrame.setMinimumSize(new Dimension(this.dim));
        this.fullFrame.setMaximumSize(new Dimension(this.dim));
        this.fullFrame.setLocation(this.dim.width / 2 - this.fullFrame.getSize().width / 2, this.dim.height / 2 - this.fullFrame.getSize().height / 2);
        this.fullFrame.setAlwaysOnTop(false);
        this.canvas = new Panel();
        this.canvas.setBackground(Color.black);
        this.canvas.setLayout(new FlowLayout());
        this.fullFrame.setBackground(Color.black);
        this.setBackground(Color.black);
        this.fullFrame.setLayout(new FlowLayout());
        this.fullFrame.setLayout(new BorderLayout());
        this.fullFrame.add((Component)this.canvas, "Center");
        this.fullFrame.pack();
        this.screen3D = new JPanel();
        this.screen3D.addFocusListener(this);
        this.screen3D.addMouseListener(this);
        this.addMouseListener(this);
        try {
            URL Mask = this.getClass().getResource("3db.png");
            this.mask = new BufferedImage(768, 544, 2);
            this.maskedges = ImageIO.read(Mask);
            URL Mask2 = this.getClass().getResource("3d.png");
            this.mask2 = ImageIO.read(Mask2);
            URL Glance = this.getClass().getResource("glass.png");
            this.glance = ImageIO.read(Glance);
            URL Patt = this.getClass().getResource("pattern.png");
            BufferedImage bum = ImageIO.read(Patt);
            Graphics2D d = this.pattern.createGraphics();
            for (int x = 0; x < 768; x += 2) {
                for (int y = 0; y < 544; y += 2) {
                    d.drawImage((Image)bum, x, y, null);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        Graphics2D gr = this.mask.createGraphics();
        Color[] col = new Color[]{new Color(255, 0, 0, 30), new Color(0, 255, 0, 30), new Color(0, 0, 255, 30), new Color(0, 0, 0, 60)};
        gr.setColor(col[3]);
        for (int i = 0; i < 768; i += 2) {
            gr.drawLine(i, 0, i, 544);
        }
        boolean off = false;
        this.mask.createGraphics().drawImage(this.maskedges, 0, 0, 768, 544, null);
        this.halfsize = Settings.getBoolean("simple_textures", false);
        this.texsizeX = 1024;
        this.texsizeY = 512;
        this.sizex = 768;
        this.sizey = 272;
        this.offx = 128;
        this.offy = 120;
        if (!this.halfsize) {
            this.texsizeX = 1024;
            this.texsizeY = 1024;
            this.sizex = 768;
            this.sizey = 544;
            this.offx = 128;
            this.offy = 240;
        }
        System.out.println("3d texture is " + this.texsizeX + "," + this.texsizeY + " Pixels.");
        this.display = new BufferedImage(this.texsizeX, this.texsizeY, 1);
        this.raster = this.display.getRaster();
        this.pixels = new int[this.texsizeX * this.texsizeY];
        this.g = this.display.getGraphics();
        this.but1 = new JRadioButton("Filled");
        this.but2 = new JRadioButton("Wireframe");
        this.but3 = new JRadioButton("Dots");
        this.but1.setFocusable(false);
        this.but2.setFocusable(false);
        this.but3.setFocusable(false);
        this.but1.setSelected(true);
        this.buts.setLayout(new FlowLayout());
        this.buts.setBackground(Color.black);
        this.but.add(this.but1);
        this.but.add(this.but2);
        this.but.add(this.but3);
        this.fps = new JLabel();
        this.buts.add(this.but1);
        this.buts.add(this.but2);
        this.buts.add(this.but3);
        this.buts.add(this.fps);
        this.buts.setFocusable(false);
        this.universe = new ConfiguredUniverse();
        this.universe.setVisible(false);
        this.group = new BranchGroup();
        this.loader = new TextureLoader((Image)this.display, 2, (Component)new Container());
        this.texture = (Texture2D)this.loader.getTexture();
        this.texture.setBoundaryColor(new Color4f(0.0f, 1.0f, 0.0f, 0.0f));
        this.texture.setCapability(7);
        this.imagecomponent = new ImageComponent2D(1, this.display);
        this.imagecomponent.setCapability(3);
        TextureAttributes texAttr = new TextureAttributes();
        texAttr.setTextureMode(2);
        texAttr.setTextureTransform(new Transform3D());
        this.appearance = new Appearance();
        this.appearance.setTexture(this.texture);
        TexCoordGeneration texcoord = new TexCoordGeneration();
        Vector4f v1 = new Vector4f(1.06f, 0.0f, 0.0f, 0.5f);
        texcoord.setPlaneS(v1);
        Vector4f v2 = new Vector4f(0.0f, 1.06f, 0.0f, 0.5f);
        texcoord.setPlaneT(v2);
        this.appearance.setTexCoordGeneration(texcoord);
        this.appearance.setTextureAttributes(texAttr);
        this.appearance.setCapability(3);
        this.polygonattributes = new PolygonAttributes();
        this.polygonattributes.setCapability(3);
        this.polygonattributes.setPolygonMode(2);
        this.appearance.setPolygonAttributes(this.polygonattributes);
        this.primflags = 3;
        this.sphere = new Sphere(1.56f, this.primflags, 256, this.appearance);
        this.group.addChild(this.sphere);
        this.universe.getViewingPlatform().setNominalViewingTransform();
        this.universe.getCanvas().setBackground(Color.BLACK);
        this.universe.addBranchGraph(this.group);
        this.display.setAccelerationPriority(1.0f);
        this.setRenderMode(0);
        this.init();
        this.ispainted = true;
        this.startoff = this.offx + this.texsizeY * this.offy * (this.halfsize ? 2 : 1);
    }

    public void update(int[] sourcepixels, boolean usemask) {
        if (this.Display.skip) {
            boolean bl = this.toggleit = !this.toggleit;
            if (this.toggleit) {
                this.ispainted = true;
                jemu.ui.Display.painted = true;
                return;
            }
        }
        if (this.firsttime < 10) {
            ++this.firsttime;
            this.screen3D.requestFocus();
        }
        if (this.spixels == null || this.spixels.length != sourcepixels.length) {
            this.spixels = new int[sourcepixels.length];
        }
        this.repaint = false;
        if (this.forcedraw >= 10) {
            this.forcedraw = 0;
            this.repaint = true;
        } else {
            for (int i = 0; i < this.spixels.length; i += 2) {
                if (this.spixels[i] == sourcepixels[i]) continue;
                this.repaint = true;
                break;
            }
        }
        if (!this.repaint) {
            ++this.forcedraw;
            this.ispainted = true;
            jemu.ui.Display.painted = true;
            return;
        }
        this.forcedraw = 0;
        System.arraycopy(sourcepixels, 0, this.spixels, 0, this.spixels.length);
        this.imask = usemask;
        this.updateImage();
    }

    protected void updateImage() {
        this.frame = 0;
        this.imageoffset = this.startoff;
        this.y = 0;
        while (this.y < (this.halfsize ? 272 : 544)) {
            System.arraycopy(this.spixels, 768 * this.y * (this.halfsize ? 2 : 1), this.pixels, this.imageoffset, 768);
            this.imageoffset += this.texsizeX;
            ++this.y;
        }
        this.raster.setDataElements(0, 0, this.texsizeX, this.texsizeY, this.pixels);
        if (this.imask) {
            if (Switches.mask) {
                this.g.drawImage(this.mask2, this.offx, this.offy, this.sizex, this.sizey, null);
                this.g.drawImage(this.glance, this.offx + 500, this.offy, 248, this.halfsize ? 207 : 414, null);
            } else {
                this.g.drawImage(this.mask, this.offx, this.offy, this.sizex, this.sizey, null);
            }
        }
        this.imagecomponent.set(this.display);
        this.ispainted = true;
        jemu.ui.Display.painted = true;
    }

    protected void update(final BufferedImage image, final boolean imask) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CurvaturedScreen.this.frame = 0;
                CurvaturedScreen.this.g.drawImage(image, CurvaturedScreen.this.offx, CurvaturedScreen.this.offy, 768, CurvaturedScreen.this.halfsize ? 272 : 544, null);
                if (imask) {
                    if (Switches.mask) {
                        CurvaturedScreen.this.g.drawImage(CurvaturedScreen.this.mask2, CurvaturedScreen.this.offx, CurvaturedScreen.this.offy, CurvaturedScreen.this.sizex, CurvaturedScreen.this.sizey, null);
                        CurvaturedScreen.this.g.drawImage(CurvaturedScreen.this.glance, CurvaturedScreen.this.offx + 500, CurvaturedScreen.this.offy, 248, CurvaturedScreen.this.halfsize ? 207 : 414, null);
                    } else {
                        CurvaturedScreen.this.g.drawImage(CurvaturedScreen.this.mask, CurvaturedScreen.this.offx, CurvaturedScreen.this.offy, CurvaturedScreen.this.sizex, CurvaturedScreen.this.sizey, null);
                    }
                }
                CurvaturedScreen.this.imagecomponent.set(CurvaturedScreen.this.display);
                CurvaturedScreen.this.ispainted = true;
                Display cfr_ignored_0 = CurvaturedScreen.this.Display;
                jemu.ui.Display.painted = true;
            }
        });
    }
}

